/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_32_h__
#define __REG_32_h__

/* ***********************************************************************
   *                                                                     *
   * regx32.h                                                            *
   * Tilmann Wendel , BID R&D, 22. Oct. 1997                             *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   * lockable set functions (preparations AND programming of sequencer)  *
   *                                                                     *
   ***********************************************************************
*/


#include "regxdir.h"   /* contains CMD_MERGE and CMDG_PROTOCOLSET_0 */


#define MERGE_TRCSET_0(cmd)	CMD_MERGE (CMDG_TRACESET_0, cmd)

/* BestTrigSeqProg() */
#define CMDM_TRC_TRIGPROG	0x05
#define CMD_TRC_TRIGPROG	MERGE_TRCSET_0 (CMDM_TRC_TRIGPROG)
#define IN_TRC_TRIGPROG		0
#define OUT_TRC_TRIGPROG	0

/* BestTrigSeqGenPropSet() */
#define CMDM_TRCTRIG_GENPROPSET	0x06
#define CMD_TRCTRIG_GENPROPSET	MERGE_TRCSET_0 (CMDM_TRCTRIG_GENPROPSET)
#define IN_TRCTRIG_GENPROPSET	8   /*  */
#define OUT_TRCTRIG_GENPROPSET	0

/* BestTrigSeqTranPropSet() */
#define CMDM_TRCTRIG_TRANPROPSET	0x08
#define CMD_TRCTRIG_TRANPROPSET		MERGE_TRCSET_0 (CMDM_TRCTRIG_TRANPROPSET)
#define IN_TRCTRIG_TRANPROPSET		12 /* transient, prop and propvalue */
#define OUT_TRCTRIG_TRANPROPSET		0

/* BestTrigSeqTranCondPropSet() */
#define CMDM_TRCTRIG_TRANCONDPROPSET	0x0a
#define CMD_TRCTRIG_TRANCONDPROPSET	MERGE_TRCSET_0 (CMDM_TRCTRIG_TRANCONDPROPSET)
#define IN_TRCTRIG_TRANCONDPROPSET	B_LENGTH_NEGOTIATE
#define OUT_TRCTRIG_TRANCONDPROPSET	0

/* BestTrigSeqPropDefaultSet() */
#define CMDM_TRCTRIG_PROPDEFAULTSET	0x0b
#define CMD_TRCTRIG_PROPDEFAULTSET	MERGE_TRCSET_0 (CMDM_TRCTRIG_PROPDEFAULTSET)
#define IN_TRCTRIG_PROPDEFAULTSET	0
#define OUT_TRCTRIG_PROPDEFAULTSET	0

/* BestTrigSeqTranPropDefaultSet() */
#define CMDM_TRCTRIG_TRANPROPDEFAULTSET	0x0c
#define CMD_TRCTRIG_TRANPROPDEFAULTSET	MERGE_TRCSET_0 (CMDM_TRCTRIG_TRANPROPDEFAULTSET)
#define IN_TRCTRIG_TRANPROPDEFAULTSET	4
#define OUT_TRCTRIG_TRANPROPDEFAULTSET	0

/* BestTracePropSet() */
#define CMDM_TRC_PROP_SET	0x10
#define CMD_TRC_PROP_SET	MERGE_TRCSET_0 (CMDM_TRC_PROP_SET)
#define IN_TRC_PROP_SET	5  /* prop (1 Byte) + value (4 Byte) */
#define OUT_TRC_PROP_SET	0

/* BestTracePattPropSet() */
#define CMDM_TRC_PATTPROPSET	0x20
#define CMD_TRC_PATTPROPSET	MERGE_TRCSET_0 (CMDM_TRC_PATTPROPSET)
#define IN_TRC_PATTPROPSET	B_LENGTH_NEGOTIATE
#define OUT_TRC_PATTPROPSET	0

/* trigger io commands ..... */
/* new TW 22.01.98 */
/* BestTrigIOProg() */
#define CMDM_TRIGIO_SEQPROG	0x40
#define CMD_TRIGIO_SEQPROG	MERGE_TRCSET_0 (CMDM_TRIGIO_SEQPROG)
#define IN_TRIGIO_SEQPROG	0
#define OUT_TRIGIO_SEQPROG	0

/* BestTrigIOGenPropSet() */
#define CMDM_TRIGIO_GENPROPSET	0x41
#define CMD_TRIGIO_GENPROPSET	MERGE_TRCSET_0 (CMDM_TRIGIO_GENPROPSET)
#define IN_TRIGIO_GENPROPSET	8   
#define OUT_TRIGIO_GENPROPSET	0 

/* BestTrigIOTranPropSet() */
#define CMDM_TRIGIO_TRANPROPSET	        0x42
#define CMD_TRIGIO_TRANPROPSET		MERGE_TRCSET_0 (CMDM_TRIGIO_TRANPROPSET)
#define IN_TRIGIO_TRANPROPSET		12 /* transient, prop and propvalue */
#define OUT_TRIGIO_TRANPROPSET		0

/* BestTrigIOTranCondPropSet() */
#define CMDM_TRIGIO_TRANCONDPROPSET	0x43
#define CMD_TRIGIO_TRANCONDPROPSET	MERGE_TRCSET_0 (CMDM_TRIGIO_TRANCONDPROPSET)
#define IN_TRIGIO_TRANCONDPROPSET	B_LENGTH_NEGOTIATE
#define OUT_TRIGIO_TRANCONDPROPSET	0

/* BestTrigIOPropDefaultSet() */
#define CMDM_TRIGIO_PROPDEFAULTSET	0x44
#define CMD_TRIGIO_PROPDEFAULTSET	MERGE_TRCSET_0 (CMDM_TRIGIO_PROPDEFAULTSET)
#define IN_TRIGIO_PROPDEFAULTSET	0
#define OUT_TRIGIO_PROPDEFAULTSET	0

/* BestTrigIOTranPropDefaultSet() */
#define CMDM_TRIGIO_TRANPROPDEFAULTSET	0x45
#define CMD_TRIGIO_TRANPROPDEFAULTSET	MERGE_TRCSET_0 (CMDM_TRIGIO_TRANPROPDEFAULTSET)
#define IN_TRIGIO_TRANPROPDEFAULTSET	4
#define OUT_TRIGIO_TRANPROPDEFAULTSET	0


#endif
